--/****** Object:  View [dbo].[V_EST_PROD_CPL_VD_MESES]    Script Date: 08/15/2012 09:49:19 ******/
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_EST_PROD_CPL_VD_MESES]'))
DROP VIEW [dbo].[V_EST_PROD_CPL_VD_MESES]
GO
GO
CREATE VIEW V_EST_PROD_CPL_VD_MESES
AS

WITH Ano_mes
  AS (SELECT
      YEAR(DATEADD(MONTH, -1, GETDATE())) * 100 + MONTH(DATEADD(MONTH, -1, GETDATE())) ANO_MES_01
     , YEAR(DATEADD(MONTH, -2, GETDATE())) * 100 + MONTH(DATEADD(MONTH, -2, GETDATE())) ANO_MES_02
     , YEAR(DATEADD(MONTH, -3, GETDATE())) * 100 + MONTH(DATEADD(MONTH, -3, GETDATE())) ANO_MES_03
     , YEAR(GETDATE()) * 100 + MONTH(GETDATE()) ANO_MES_ATU)
  SELECT
   A.CD_EMP
    , A.CD_FILIAL
    , A.CD_PROD
    , SUM(CASE WHEN A.ANO_MES = B.ANO_MES_ATU THEN QT_VD ELSE 0
    END) AS QT_VD_ATUAL
    , SUM(CASE WHEN A.ANO_MES = B.ANO_MES_ATU THEN VLR_VD ELSE 0
    END) AS VLR_VD_ATUAL
    , SUM(CASE WHEN A.ANO_MES = B.ANO_MES_01 THEN QT_VD ELSE 0
    END) AS QT_VD_01
    , SUM(CASE WHEN A.ANO_MES = B.ANO_MES_01 THEN VLR_VD ELSE 0
    END) AS VLR_VD_01
    , SUM(CASE WHEN A.ANO_MES = B.ANO_MES_02 THEN QT_VD ELSE 0
    END) AS QT_VD_02
    , SUM(CASE WHEN A.ANO_MES = B.ANO_MES_02 THEN VLR_VD ELSE 0
    END) AS VLR_VD_02
    , SUM(CASE WHEN A.ANO_MES = B.ANO_MES_03 THEN QT_VD ELSE 0
    END) AS QT_VD_03
    , SUM(CASE WHEN A.ANO_MES = B.ANO_MES_03 THEN VLR_VD ELSE 0
    END) AS VLR_VD_03
  FROM
   EST_PROD_CPL_VD A
   JOIN ANO_MES B ON 
   A.ANO_MES BETWEEN B.ANO_MES_03 AND B.ANO_MES_ATU
  --WHERE A.CD_PROD=25287
  GROUP BY
     A.CD_EMP
   , A.CD_FILIAL
   , A.CD_PROD;